* mdNameCOMExample.prg
*
* Melissa Data mdName API for Visual FoxPro (via COM)
* Copyright 1993-2007 Melissa Data Corporation.

*********************************************************************************
*If you should have any comments, suggestions or improvements to these samples, 
*we welcome you to contact us at SampleCode@melissadata.com also please visit our 
*developers bulletin board at forum.melissadata.com.
*********************************************************************************

#include "mdName.h"

* Change the following lines to reflect your installation location
*   of the mdName API and the license string:
* The Data Files Directory must contain the following files: mdName.dat and mdName.cfg.
#define dFILELOC "C:\Program Files\Melissa DATA\DQT\Data"

	*********************** LICENSE STRINGS **********************
	*     To unlock the full functionality of Name Object,       *
	*     	     Or to obtain a Demo License String              *
	* please call a sales representative at 1-800-MELISSA ext. 3 *
	*         (1-800-635-4772 x3) for a license string.          *
	*    Replace DEMO with your valid license string...          *
	**************************************************************
        	
#define dLICENSE "DEMO"

* Modify the screen font so that it displayes a little neater:
Modify Window Screen Font "Courier New",11

*Create the COM object:
Name=CreateObject("mdNameObj.mdName")


If Name.SetLicenseString(dLICENSE)==0
  ? "Error setting License to "+dLICENSE
  ? "Please contact a Melissa Data sales representative at 1-800-800-6245 x3 for a valid license string."
  Return
EndIf

Name.PathToNameFiles=dFILELOC
If Name.InitializeDataFiles()!= 0
  ? "Error Initializing mdName: "+Name.GetInitializeErrorString()
  Return
EndIf

* Set a few processing options:
Name.PrimaryNameHint=mdNameDefinitelyFull
Name.FirstNameSpellingCorrection=1
Name.SalutationPrefix="Dear"
Name.SalutationSuffix=":"
Name.SalutationSlug="Valued Customer"

Record=1

* Process the sample data file:
hFile=FOpen("./mdName.sdf")
FullName=FGets(hFile)
Do While !Empty(FullName)
	Name.ClearProperties()
	Name.FullName=FullName
	Name.Parse()
	? "  "
	? "Record "+STR(Record,2)+" Full Name: "+FullName
	? "            Gender1: "+Name.Gender
	? "            Prefix1: "+Name.Prefix
	? "        First Name1: "+Name.FirstName
	? "       Middle Name1: "+Name.MiddleName
	? "         Last Name1: "+Name.LastName
	? "            Suffix1: "+Name.Suffix
	? "            Gender2: "+Name.Gender2
	? "            Prefix2: "+Name.Prefix2
	? "        First Name2: "+Name.FirstName2
	? "       Middle Name2: "+Name.MiddleName2
	? "         Last Name2: "+Name.LastName2
	? "            Suffix2: "+Name.Suffix2
	? "         Salutation: "+Name.Salutation
	
	* Results Codes are returned as a delimited string, so we parse here...
    ? " Results...."
    if "NS01"$Name.Results 
       ? "NS01: There were no Errors."
    endif
    if "NS03"$Name.Results
       ? "NS03: The spelling of the FirstName field was corrected."
    endif
    if "NS04"$Name.Results
       ? "NS04: The spelling of the FirstName2 field was corrected."
    endif
    if "NS02"$Name.Results
        ? "NS02: There was an Error."
        if "NE01"$Name.Results
           ? "NE01: Two names were detected but the FullName string was not in a recognized format."
        endif
        if "NE02"$Name.Results
           ? "NE02: Multiple first names  could not accurately genderize."
        endif
        if "NE03"$Name.Results
           ? "NE03: A vulgarity was detected in the name."
        endif
        if "NE04"$Name.Results
           ? "NE04: The name contained words found on the list of nuisance names (such as Mickey Mouse)."
        endif
        if "NE05"$Name.Results
           ? "NE05: The name contained words normally found in a company name."
        endif
        if "NE06"$Name.Results
           ? "NE06: The named contained a non-alphabetic character."
        endif
        ? " " 
    endif

	Record=Record+1
	FullName=FGETS(hFile)
EndDo
FClose(hFile)
Release Name
